actions :add
default_action :add

property :repo_name, :kind_of => String, :name_attribute => true
property :uri, :kind_of => String
property :distribution, :kind_of => String
property :components, :kind_of => Array, :default => []
property :key_server, :kind_of => String, :default => nil
property :key, :kind_of => String, :default => nil
property :keys, :kind_of => Array, :default => []
property :filters, :kind_of => Array, :default => []

action :add do

  keys = [new_resource.keys, new_resource.key].flatten.select{|key| key != nil}

  keys.each do |key|
    execute "gpg install remote key #{key}" do
      command "gpg --no-default-keyring --keyring trustedkeys.gpg --keyserver #{new_resource.key_server} --recv-keys #{key}"

      user node['aptly']['user']
      group node['aptly']['group']

      extend SdsAptly::Helpers
      environment env_execute

      retries 5
      retry_delay 3

      not_if "gpg --no-default-keyring --keyring trustedkeys.gpg --list-keys | grep /#{key}"
    end
  end

  execute "aptly mirror create #{new_resource.repo_name}" do
    extend SdsAptly::Helpers
    command cmd_mirror_create(new_resource)

    user node['aptly']['user']
    group node['aptly']['group']
    environment env_execute

    retries 5
    retry_delay 3

    not_if "aptly mirror -raw list | grep ^#{new_resource.repo_name}$"
    #notifies :run, "execute[aptly mirror update #{new_resource.repo_name}]", :immediately
  end

  update_stamp = ::File.join(node['aptly']['root_dir'], ".#{new_resource.repo_name}-update-stamp")

  file update_stamp do
    user node['aptly']['user']
    group node['aptly']['group']

    action :nothing
  end

  execute "aptly mirror update #{new_resource.repo_name}" do
    extend SdsAptly::Helpers

    user node['aptly']['user']
    group node['aptly']['group']
    environment env_execute

    retries 5
    retry_delay 3

    timeout 60 * 60 * 6 # This can take a long freaking time that first run.

    not_if do
      ::File.exists?(update_stamp) && ::File.mtime(update_stamp) > Time.now - node['aptly']['periodic_mirror_update_delay']
    end
    notifies :touch, "file[#{update_stamp}]"
  end

  snapshot_name = "#{new_resource.repo_name}-#{Time.now.strftime '%Y-%m'}"
  execute "aptly snapshot create #{new_resource.repo_name}" do
    command "aptly snapshot create #{snapshot_name} from mirror #{new_resource.repo_name}"

    user node['aptly']['user']
    group node['aptly']['group']

    extend SdsAptly::Helpers
    environment env_execute

    not_if "aptly snapshot list -raw | grep ^#{snapshot_name}$"
  end

end
