require 'chef/mixin/shell_out'
include Chef::Mixin::ShellOut

actions :create
default_action :create

state_attrs :name, :pattern, :timestamp, :latest

property :name, :kind_of => String, :name_attribute => true
property :timestamp, :kind_of => String, :default => Time.now.strftime('%Y-%m')

action :create do

  execute "aptly publish #{new_resource.name}" do
    extend SdsAptly::Helpers
    command cmd_publish_snapshot(new_resource)

    user node['aptly']['user']
    group node['aptly']['group']
    environment env_execute

    not_if "aptly publish list -raw | grep '^. #{new_resource.name}$'"
  end

end
