include_recipe "#{cookbook_name}::install"

base_dir = node['consul']['base_dir']

template "#{base_dir}/etc/consul.json" do
  source 'consul_client.json.erb'
  helper(:node_name) { node['consul']['node_name'] }
  helper(:data_dir) { "#{base_dir}/data" }
  helper(:advertise_addr) { node['ipaddress'] }
  helper(:clustered?) { node['consul']['cluster']['enabled'] }
  helper(:cluster_region) { node['consul']['cluster']['region'] }
  helper(:cluster_tag_key) { node['consul']['cluster']['tag_key'] }
  helper(:cluster_name) { node['consul']['cluster']['name'] }

  notifies :restart, 'service[consul]', :delayed
end

service 'consul' do
  action [:enable, :start]
end