
if node['consul']['cluster']['enabled']
  raise "You must specify an ec2 region in clustered mode (node['consul']['cluster']['region']" if node['consul']['cluster']['region'] == ''
  raise "You must specify an ec2 tag search value in clustered mode (node['consul']['cluster']['name']" if node['consul']['cluster']['name'] == ''
end

base_dir = node['consul']['base_dir']

directory base_dir do
  recursive true
end

user 'consul' do
  manage_home true
  home base_dir
  shell '/bin/bash'
  password ''
  notifies :run, 'execute[del-consul-pw]', :immediately
end

execute 'del-consul-pw' do
  command '/usr/bin/passwd -d consul'
  action :nothing
end

%W(
  packages
  bin
  etc
  data
).each do |dir|
  directory "#{base_dir}/#{dir}" do
    mode 0700
    owner 'consul'
    group 'consul'
    recursive true
  end
end

package 'unzip'

remote_file "#{base_dir}/packages/#{File.basename(node['consul']['package_url'])}" do
  source node['consul']['package_url']
  checksum node['consul']['package_sum']
  notifies :run, 'execute[extract consul]', :immediately
end

execute 'extract consul' do
  command "unzip #{base_dir}/packages/#{File.basename(node['consul']['package_url'])} && chown -R consul:consul #{base_dir}"
  cwd "#{base_dir}/bin"
  action :nothing
  notifies :restart, 'service[consul]', :delayed
end

template '/etc/systemd/system/consul.service' do
  source 'consul.systemd.service.erb'
  helper(:base_dir) { base_dir }
  mode 0700
end
