include_recipe "#{cookbook_name}::install"

base_dir = node['consul']['base_dir']

template "#{base_dir}/etc/consul.json" do
  source 'consul_server.json.erb'
  helper(:node_name) { node['consul']['node_name'] }
  helper(:data_dir) { "#{base_dir}/data" }
  helper(:advertise_addr) { node['ipaddress'] }
  helper(:clustered?) { node['consul']['cluster']['enabled'] }
  helper(:cluster_region) { node['consul']['cluster']['region'] }
  helper(:cluster_tag_key) { node['consul']['cluster']['tag_key'] }
  helper(:cluster_name) { node['consul']['cluster']['name'] }

  notifies :restart, 'service[consul]', :delayed
end

service 'consul' do
  action [:enable, :start]
end

if node['consul']['backup']['enable']
  remote_file "#{base_dir}/bin/#{File.basename(node['consul']['snapshot_url'])}" do
    source node['consul']['snapshot_url']
    mode 0700
    checksum node['consul']['snapshot_sum']
  end

  include_recipe 'poise-python::default'

  python_package 'awscli' do
    action :upgrade
  end

  template "#{base_dir}/bin/consul-backup.rb" do
    source 'consul-backup.rb.erb'
    helper(:base_dir) { base_dir }
    helper(:s3_prefix) { node['consul']['backup']['s3_prefix'] }
    mode 0700
    owner 'root'
    group 'root'
  end

  cron 'backup consul' do
    user 'root'
    minute 0
    command %W{
            #{base_dir}/bin/consul-backup.rb > /dev/null 2>&1
  }.join(' ')
    only_if { get_zone == 'a' }
  end
end