#
# Cookbook:: sds_docker
# Recipe:: default
#
# Copyright:: 2017, Curse, All Rights Reserved.

execute 'update-grub' do
  command '/usr/sbin/update-grub'
  action :nothing
end

file '/etc/grub.d/99-docker.cfg' do
  content 'GRUB_CMDLINE_LINUX_DEFAULT="${GRUB_CMDLINE_LINUX_DEFAULT} cgroup_enable=memory swapaccount=1"'
  owner 'root'
  group 'root'
  mode '0644'
  notifies :run, 'execute[update-grub]', :immediately
end

include_recipe 'chef-apt-docker'

docker_service 'default' do
  install_method 'package'
  version node['docker']['version']
  host ['unix:///var/run/docker.sock']

  dns node['docker']['dns_servers'] unless node['docker']['dns_servers'].empty?

  cluster_store "consul://#{node['docker']['consul_addr']}:8500" if node['docker']['consul_enable']
  cluster_advertise "#{node['docker']['consul_addr']}:0" if node['docker']['consul_enable']

  # labels %W(region:#{env} zone:#{zone})
  systemd_opts ["TasksMax=infinity","MountFlags=private"]

  action [:create, :start]
end

cookbook_file '/usr/local/bin/docker-credential-ecr-login' do
  source 'docker-credential-ecr-login'
  mode '0755'
end

cookbook_file '/usr/local/bin/docker-clean' do
  source 'docker-clean'
  mode '0755'
end

cron 'docker-clean' do
  command '/usr/local/bin/docker-clean > /dev/null 2>&1'
  minute '0'
  hour '0'
end
