# frozen_string_literal: true

default['influxdb']['version'] = '1.7.4'
default['influxdb']['download_repository'] = 'https://dl.influxdata.com/enterprise/releases'

default['influxdb']['checksums']['data']['debian']['1.3.3'] = '4ee4eab05f44bec1ffd71c09c5c1b66aa785b4ce7c44bbd5d0e8c5a99ddfa042'
default['influxdb']['checksums']['meta']['debian']['1.3.3'] = '1f532428fc4088209da9470ac46baebbb8ec91419f8d428dc9088b39dacb54d9'
default['influxdb']['checksums']['data']['debian']['1.3.5'] = '87d99ba4a90487ee1a9737cfaa18822a6693a252a1fc56d4bea93cc19f7d9985'
default['influxdb']['checksums']['meta']['debian']['1.3.5'] = '4c17e7d3bac8f565c140d3613db4e5f4a3afd2ffc0b4c327f9a97b8188160ef1'
default['influxdb']['checksums']['data']['debian']['1.3.7'] = '779487a83c5f2b113c4788e740c7b6d46ea1fa58fa35b7985be84d431f357337'
default['influxdb']['checksums']['meta']['debian']['1.3.7'] = '37bf45df0994a233919a54e0d412bc903c6a0dd736c558f2a0488156bf69a0c6'
default['influxdb']['checksums']['data']['debian']['1.5.1'] = 'c7e391a17591bbfc50cafd88859cb1eebf7da4f4d5b3ff09777985c3af274075'
default['influxdb']['checksums']['meta']['debian']['1.5.1'] = 'e231c2041579ef2e7d536905d6050bf69e0223578d6069e0cc9c5a63e2d0d3ee'
default['influxdb']['checksums']['data']['debian']['1.5.2'] = '3fb619f47b4cf7d3d3e4b7396a2d29d148a006b1c3a85bb88f5635d288dbc1b2'
default['influxdb']['checksums']['meta']['debian']['1.5.2'] = '5a9158319290654f61146b6062caaf46009374bdb6616e00c68fd765ae4a8ce0'
default['influxdb']['checksums']['data']['debian']['1.7.4'] = 'bf62c09038dd63376e382a8be60ade3e362f0e0bc1cec8381927811a4e1e363f'
default['influxdb']['checksums']['meta']['debian']['1.7.4'] = 'b3d651a702a3c73ee34ca7d8d689155ca981e9d274e057699eb4b502c6efd2cb'

default['influxdb']['meta']['config_file'] = '/etc/influxdb/influxdb-meta.conf'
default['influxdb']['meta']['config'] = {
  'reporting-disabled': true, # Option to disable statistics reporting to influxdata.
  'bind-address': ':8091', # The TCP bind address to use for the cluster-internal meta services.
  'hostname': '', # Hostname advertised by this host for remote addresses.  This must be resolvable by all other nodes in the cluster.
  'enterprise': {
    'registration-enabled': false, # Must be set to true to use the Enterprise Web UI (and chronograph?)
    'registration-server-url': '', # Must include the protocol (http://)
    'license-key': '', # license-key and license-path are mutually exclusive, use only one and leave the other blank
    'license-path': ''
  },
  'meta': {
    'dir': '/mnt/influxdb_data/meta', # Directory where cluster meta data is stored.
    'bind-address': ':8089', # The default address for raft, cluster, snapshot, etc.
    'http-bind-address': ':8091', # The default address to bind the API to.
    'https-enabled': false, # Determines whether the API uses HTTPS.
    'https-certificate': '', # The SSL certificate to use when HTTPS is enabled.  The certificate should be a PEM encoded bundle of the certificate and key.  If it is just the certificate, a key must be specified in https-private-key.
    'https-private-key': '', # Use a separate private key location. (when not using a PEM)
    'https-insecure-tls': false, # Whether to skip certificate validation when making HTTPS requests to other meta nodes. This is useful when testing with self-signed certificates.
    'gossip-frequency': '5s', # The default frequency with which the node will gossip its known announcements.
    'announcement-expiration': '30s', # The default length of time an announcement is kept before it is considered too old.
    'retention-autocreate': true, # Automatically create a default retention policy when creating a database.
    'election-timeout': '1s', # The amount of time in candidate state without a leader before we attempt an election.
    'heartbeat-timeout': '1s', # The amount of time in follower state without a leader before we attempt an election.
    'leader-lease-timeout': '500ms', # Control how long the 'lease' lasts for being the leader without being able to contact a quorum of nodes. If we reach this interval without contact, we will step down as leader.
    'commit-timeout': '50ms', # The amount of time without an Apply() operation before we heartbeat to ensure a timely commit. Due to random staggering, may be delayed as much as 2x this value.
    'consensus-timeout': '30s', # Timeout waiting for consensus before getting the latest Raft snapshot.
    'cluster-tracing': false, # Enables cluster level trace logging.
    'logging-enabled': true, # Enables cluster API level trace logging.
    'pprof-enabled': true, # Determines whether the pprof endpoint is enabled.  This endpoint is used for troubleshooting and monitoring.
    'lease-duration': '1m0s', # The default duration of leases.
    'auth-enabled': false, # If true, HTTP endpoints require authentication.
    'shared-secret': '', # The shared secret used by the API for JWT authentication.
    'internal-shared-secret': '' # The shared secret used by the internal API for JWT authentication.
  }
}

default['influxdb']['data']['config_file'] = '/etc/influxdb/influxdb.conf'
default['influxdb']['data']['config'] = {
  'reporting-disabled': false, # Option to disable statistics reporting to influxdata.
  'bind-address': ':8088', # The TCP bind address to use for cluster-internal services.
  'hostname': '', # Hostname advertised by this host for remote addresses.  This must be resolvable by all other nodes in the cluster.
  'gossip-frequency': '3s', # How often to update the cluster with this node's internal status.
  'enterprise': {
    'registration-enabled': false, # Must be set to true to use the Enterprise Web UI (and chronograph?)
    'registration-server-url': '', # Must include the protocol (http://)
    'license-key': '', # license-key and license-path are mutually exclusive, use only one and leave the other blank
    'license-path': ''
  },
  'meta': {
    'dir': '/mnt/influxdb_data/meta', # Directory where the cluster metadata is stored.
    'meta-tls-enabled': false, # Whether to use TLS when connecting to meta nodes.
    'meta-auth-enabled': false, # This setting must have the same value as the meta nodes' meta.auth-enabled configuration.
    'meta-internal-shared-secret': '', # This setting must have the same value as the meta nodes meta.internal-shared-secret configuration.
    'meta-insecure-tls': false, # Allows insecure TLS connections to meta nodes.  This is useful when testing with self-signed certificates.
    'logging-enabled': true, # Whether log messages are printed for the meta service.
  },
  'data': {
    'dir': '/mnt/influxdb_data/data', # The directory where the TSM storage engine stores TSM (read-optimized) files.
    'wal-dir': '/mnt/influxdb_wal/wal', # The directory where the TSM storage engine stores WAL (write-optimized) files.
    'trace-logging-enabled': false, # Trace logging provides more verbose output around the tsm engine. Turning this on can provide more useful output for debugging tsm engine issues.
    'query-log-enabled': true, # Whether queries should be logged before execution. Very useful for troubleshooting, but will log any sensitive data contained within a query.
    'cache-max-memory-size': 1_048_576_000, # CacheMaxMemorySize is the maximum size a shard's cache can reach before it starts rejecting writes.
    'cache-snapshot-memory-size': 26_214_400, # CacheSnapshotMemorySize is the size at which the engine will snapshot the cache and write it to a TSM file, freeing up memory.
    'cache-snapshot-write-cold-duration': '10m', # CacheSnapshotWriteColdDuration is the length of time at which the engine will snapshot the cache and write it to a new TSM file if the shard hasn't received writes or deletes.
    'max-concurrent-compactions': 0, # The maximum number of concurrent full and level compactions that can run at one time.  A value of 0 results in runtime.GOMAXPROCS(0) used at runtime.  This setting does not apply to cache snapshotting.
    'compact-full-write-cold-duration': '4h', # CompactFullWriteColdDuration is the duration at which the engine will compact all TSM files in a shard if it hasn't received a write or delete.
    'max-series-per-database': 1_000_000, # The maximum series allowed per database before writes are dropped.  This limit can prevent high cardinality issues at the database level.  This limit can be disabled by setting it to 0.
    'max-values-per-tag': 100_000, # The maximum number of tag values per tag that are allowed before writes are dropped.  This limit can prevent high cardinality tag values from being written to a measurement.  This limit can be disabled by setting it to 0.
    'index-version': 'tsi1', #Time Series Index introduced v1.5.
    'wal-fsync-delay': '0s', #default value
  },
  'cluster': {
    'dial-timeout': '1s', # The default timeout when establishing a new connection to a node.
    'pool-max-idle-time': '60s', # The default time a stream will remain idle in the connection pool before being reaped.
    'pool-max-idle-streams': 100, # The default maximum number of streams that can be idle in a pool, per node. The number of active streams can exceed the maximum, but they will not return to the pool when released.
    'shard-reader-timeout': '0', # The default timeout set on shard readers.
    'cluster-tracing': false, # Enables cluster trace logging.
    'write-timeout': '10s', # The default time a write request will wait until a 'timeout' error is returned to the caller.
    'max-concurrent-queries': 0, # The maximum number of concurrent queries allowed to be executing at one time.  If a query is executed and exceeds this limit, an error is returned to the caller.  This limit can be disabled by setting it to 0.
    'query-timeout': '0s', # The maximum time a query will is allowed to execute before being killed by the system.  This limit can help prevent run away queries.  Setting the value to 0 disables the limit.
    'log-queries-after': '0s', # The time threshold when a query will be logged as a slow query.  This limit can be set to help discover slow or resource intensive queries.  Setting the value to 0 disables the slow query logging.
    'max-select-point': 0, # The maximum number of points a SELECT can process.  A value of 0 will make the maximum point count unlimited.
    'max-select-series': 0, # The maximum number of series a SELECT can run. A value of zero will make the maximum series count unlimited.
    'max-select-buckets': 0, # The maximum number of group by time buckets a SELECT can create.  A value of zero will make the maximum number of buckets unlimited.
  },
  'hinted-handoff': {
    'enabled': true, # Determines whether hinted handoff is enabled.
    'dir': '/mnt/influxdb_data/hh', # The directory where the hinted handoff queues are stored.
    'max-size': 10_737_418_240, # The default maximum size of all hinted handoff queues in bytes.
    'max-age': '168h0m0s', # The default maximum amount of time that a hinted handoff write can stay in the queue. After this time, the write will be purged.
    'retry-concurrency': 20, # The maximum number of concurrent queued writes to process at a time.
    'retry-rate-limit': 0, # The default rate that hinted handoffs will be retried.  The rate is in bytes per second and applies across all nodes when retried.   A value of 0 disables the rate limit.
    'retry-interval': '1s', # The default amount of time the system waits before attempting to flush hinted handoff queues. With each failure of a hinted handoff write, this retry interval increases exponentially until it reaches the maximum.
    'retry-max-interval': '10s', # The maximum the hinted handoff retry interval will ever be.
    'purge-interval': '1m0s', # The amount of time the system waits before attempting to purge hinted handoff data due to age or inactive nodes.
    'batch-size': 512_000, # Maximum number of bytes to write to a shard in a single request
  },
  'anti-entropy': {
    'enabled': false, # Determines whether the service is enabled.
    'check-interval': '30s', # The interval of time when anti-entropy checks run on each data node.
    'max-fetch': 10, # The maximum number of shards that a single data node will copy or repair in parallel.
  },
  'retention': {
    'enabled': true, # Determines whether retention policy enforcement enabled.
    'check-interval': '30m', # The interval of time when retention policy enforcement checks run.
  },
  'shard-precreation': {
    'enabled': true, # Determines whether shard pre-creation service is enabled.
    'check-interval': '10m', # The interval of time when the check to pre-create new shards runs.
    'advance-period': '30m', # The default period ahead of the endtime of a shard group that its successor group is created.
  },
  'monitor': {
    'store-enabled': false, # Whether to record statistics internally.
    'store-database': '_internal', # The destination database for recorded statistics.
    'store-interval': '10s', # The interval at which to record statistics.
    'remote-collect-interval': '10s', # How often to poll other data nodes' stats when aggregating cluster stats.
  },
  'http': {
    'enabled': true, # Determines whether HTTP endpoint is enabled.
    'bind-address': ':8086', # The bind address used by the HTTP service.
    'auth-enabled': false, # Determines whether HTTP authentication is enabled.
    'realm': 'InfluxDB', # The default realm sent back when issuing a basic auth challenge.
    'log-enabled': true, # Determines whether HTTP request logging is enabled.
    'write-tracing': false, # Determines whether detailed write logging is enabled.
    'pprof-enabled': true, # Determines whether the pprof endpoint is enabled.  This endpoint is used for troubleshooting and monitoring.
    'https-enabled': false, # Determines whether HTTPS is enabled.
    'https-certificate': '/etc/ssl/influxdb.pem', # The SSL certificate to use when HTTPS is enabled.  The certificate should be a PEM encoded bundle of the certificate and key.  If it is just the certificate, a key must be specified in https-private-key.
    'https-private-key': '', # Use a separate private key location.
    'shared-secret': '', # The JWT auth shared secret to validate requests using JSON web tokens.
    'max-row-limit': 10_000, # The default chunk size for result sets that should be chunked.
    'max-connection-limit': 0, # The maximum number of HTTP connections that may be open at once.  New connections that would exceed this limit are dropped.  Setting this value to 0 disables the limit.
    'unix-socket-enabled': false, # Whether to enable http service over unix domain socket.
    'bind-socket': '/var/run/influxdb.sock', # The path of the unix domain socket.
  },
  'subscriber': {
    'enabled': true, # Determines whether the subscriber service is enabled.
    'http-timeout': '30s', # The default timeout for HTTP writes to subscribers.
    'insecure-skip-verify': false, # Allows insecure HTTPS connections to subscribers.  This is useful when testing with self-signed certificates.
    'ca-certs': '', # The path to the PEM encoded CA certs file. If the empty string, the default system certs will be used.
    'write-concurrency': 40, # The number of writer goroutines processing the write channel.
    'write-buffer-size': 1000, # The number of in-flight writes buffered in the write channel.
  },
  'continuous_queries': {
    'enabled': true, # Determines whether the continuous query service is enabled.
    'log-enabled': true, # Controls whether queries are logged when executed by the CQ service.
    'run-interval': '1s', # Interval for how often continuous queries will be checked whether they need to run.
  }
}
