# frozen_string_literal: true

# Cookbook:: sds_influxdb
# Recipe:: data
#
# Copyright:: 2017, Curse, All Rights Reserved.

include_recipe "#{cookbook_name}::common"

sds_influxdb_install 'influxdb-data' do
  type :data
end

influxdb_config node['influxdb']['data']['config_file'] do
  config node['influxdb']['data']['config']
end

[['meta', 'dir'], ['data', 'dir'], ['data', 'wal-dir'], ['hinted-handoff', 'dir']].each do |path|
  directory node['influxdb']['data']['config'].dig(*path) do
    recursive true
    mode 0744
    owner 'influxdb'
    group 'influxdb'
  end
end


service 'influxdb' do
  action [:enable, :start]
end
