# frozen_string_literal: true

# Cookbook:: sds_influxdb
# Recipe:: meta
#
# Copyright:: 2017, Curse, All Rights Reserved.

include_recipe "#{cookbook_name}::common"

sds_influxdb_install 'influxdb-meta' do
  type :meta
end

influxdb_config node['influxdb']['meta']['config_file'] do
  config node['influxdb']['meta']['config']
end

directory node['influxdb']['meta']['config']['meta']['dir'] do
  recursive true
  mode 0744
  owner 'influxdb'
  group 'influxdb'
end

service 'influxdb-meta' do
  action [:enable, :start]
end
