# frozen_string_literal: true

# Inspec test for recipe sds_influxdb::data

describe file('/etc/influxdb/influxdb.conf') do
  it { should be_file }
end

describe.one do
  describe ini('/etc/influxdb/influxdb.conf') do
    its(['enterprise', 'license-key']) { should_not eql '""' }
  end

  describe ini('/etc/influxdb/influxdb.conf') do
    its(['enterprise', 'license-path']) { should_not eql '""' }
  end
end

describe service('influxdb') do
  it { should be_installed }
  it { should be_enabled }
  it { should be_running }
end

describe port(8088) do
  it { should be_listening }
end

describe port(8086) do
  it { should be_listening }
end

