# frozen_string_literal: true

# Inspec test for recipe sds_influxdb::meta

describe file('/etc/influxdb/influxdb-meta.conf') do
  it { should be_file }
end

describe.one do
  describe ini('/etc/influxdb/influxdb-meta.conf') do
    its(['enterprise', 'license-key']) { should_not eql '""' }
  end

  describe ini('/etc/influxdb/influxdb-meta.conf') do
    its(['enterprise', 'license-path']) { should_not eql '""' }
  end
end

describe service('influxdb-meta') do
  it { should be_installed }
  it { should be_enabled }
  it { should be_running }
end

describe port(8089) do
  it { should be_listening }
end

describe port(8091) do
  it { should be_listening }
end

