#
# Cookbook Name:: app-nomad
# Recipe:: client
#
# Copyright (c) 2016 Curse, All Rights Reserved.

include_recipe "#{cookbook_name}::install"

base_dir = node['nomad']['base_dir']

template "#{base_dir}/etc/nomad.json" do
  source 'client.hcl.erb'
  helper(:credential_helper) { node['nomad']['credential_helper'] }
  helper(:node_name) { node['nomad']['node_name'] }
  helper(:base_dir) { base_dir }
  helper(:region) { node['nomad']['region'] }
  helper(:datacenter) { node['nomad']['datacenter'] }
  notifies :restart, 'service[nomad]', :delayed
  owner 'nomad'
  group 'nomad'
end

service 'nomad' do
  action [:enable, :start]
end
