base_dir = node['nomad']['base_dir']

directory base_dir do
  recursive true
end

user 'nomad' do
  manage_home true
  home base_dir
  shell '/bin/bash'
  password ''
  notifies :run, 'execute[del-nomad-pw]', :immediately
end

execute 'del-nomad-pw' do
  command '/usr/bin/passwd -d nomad'
  action :nothing
end

group 'docker' do
  action :modify
  members 'nomad'
  append true
end

%W(
  packages
  bin
  etc
  data
).each do |dir|
  directory "#{base_dir}/#{dir}" do
    mode 0700
    owner 'nomad'
    group 'nomad'
    recursive true
  end
end

package 'unzip'

remote_file "#{base_dir}/packages/#{File.basename(node['nomad']['package_url'])}" do
  source node['nomad']['package_url']
  checksum node['nomad']['package_sum']
  notifies :run, 'execute[extract nomad]', :immediately
end

execute 'extract nomad' do
  command "unzip -o #{base_dir}/packages/#{File.basename(node['nomad']['package_url'])} && chown -R nomad:nomad #{base_dir}"
  cwd "#{base_dir}/bin"
  action :nothing
  notifies :restart, 'service[nomad]', :delayed
end

template '/etc/systemd/system/nomad.service' do
  source 'nomad.systemd.service.erb'
  helper(:base_dir) { base_dir }
  mode 0700
end
