default['sensu']['user'] = 'root'
default['sensu']['group'] = 'root'

case node['platform']
  when 'windows'
    default['sensu']['config_directory'] = 'c:/opt/sensu'
    default['sensu']['log_directory'] = 'c:/opt/sensu/log'
    default['sensu']['secret_directory'] = 'c:/opt/sensu/secrets'
  else
    default['sensu']['config_directory'] = '/etc/sensu'
    default['sensu']['log_directory'] = '/var/log/sensu'
    default['sensu']['secret_directory'] = '/etc/sensu/secrets'
end

override['sensu']['version'] = '1.2.1-2'
override['sensu']['use_ssl'] = false
override['sensu']['transport']['name'] = 'snssqs'

default['sensu']['use_embedded_ruby'] = true
default['sensu']['log_level'] = 'info'
default['sensu']['max_wait'] = 30

default['sensu']['service_cmd'] = 'service[sensu-client]'

default["sensu"]["apt_repo_url"] = 'https://sensu.global.ssl.fastly.net/apt'
default["sensu"]["yum_repo_url"] = 'https://sensu.global.ssl.fastly.net'

default['sensu']['client_config']['subscriptions'] = []

default['sensu']['systemd']['niceness'] = 0
