#!/bin/bash
#
# chkconfig: 235 10 90
# description: TeamCity startup script
#

. /etc/rc.d/init.d/functions

start() {
  sudo -u teamcity -s -- sh -c "/opt/jetbrains/TeamCity_agent/bin/agent.sh start"
}

stop() {
  sudo -u teamcity -s -- sh -c "/opt/jetbrains/TeamCity_agent/bin/agent.sh stop"
}

restart() {
  stop
  start
}

script_result=0

case "$1" in
  start)
    start
    ;;
  status)
    status -p /opt/jetbrains/TeamCity_agent/logs/buildAgent.pid teamcity-agent
    script_result=$?
    ;;
  stop)
    stop
    ;;
  restart)
    restart
    ;;
  *)
    echo "Usage: $0 {start|stop|restart|status}"
    script_result=1
    ;;
esac

exit $script_result