#!/bin/sh

# ---------------------------------------------------------------------
# TeamCity server start/stop script
# ---------------------------------------------------------------------
# Environment variables:
#
# TEAMCITY_SERVER_MEM_OPTS   server memory options (JVM options)
#
# TEAMCITY_SERVER_OPTS       additional server JVM options
#
# TEAMCITY_DATA_PATH         path to TeamCity data directory
#
# TEAMCITY_PREPARE_SCRIPT    name of a script to execute before start/stop
#
# TEAMCITY_PID_FILE_PATH     path to a file which will contain TeamCity process ID (if not specified file with name "teamcity.pid" will be created under logs directory)
#
# ---------------------------------------------------------------------

case "$1" in
start|stop|run)
  old_cwd=`pwd`

  BIN=`dirname $0`
  cd $BIN
  BIN=`pwd`

  mkdir ../logs 2>/dev/null

  if [ -f "$BIN/teamcity-init.sh" ]; then
    . "$BIN/teamcity-init.sh"
  fi

  if [ "$TEAMCITY_SERVER_MEM_OPTS" = "" ]; then
    # Default options suitable for product evaluation
    #TEAMCITY_SERVER_MEM_OPTS="-Xmx512m"

    # Options recommended for dedicated server installation (commented by default)
    # TEAMCITY_SERVER_MEM_OPTS="-Xms4g -Xmx4g -XX:ReservedCodeCacheSize=350m"

    # We need more powah!
    TEAMCITY_SERVER_MEM_OPTS="-Xms9g -Xmx9g -XX:ReservedCodeCacheSize=448m"
  fi


  CATALINA_OPTS="$CATALINA_OPTS $TEAMCITY_SERVER_OPTS -server $TEAMCITY_SERVER_MEM_OPTS -Dteamcity.configuration.path=\"../conf/teamcity-startup.properties\" -Dlog4j.configuration=\"file:$BIN/../conf/teamcity-server-log4j.xml\" -Dteamcity_logs=../logs/ -Djava.awt.headless=true"

  export CATALINA_OPTS
  CATALINA_HOME=./..
  CATALINA_BASE=./..

  if [ "$TEAMCITY_PREPARE_SCRIPT" != "" ]; then
      "$TEAMCITY_PREPARE_SCRIPT" $*
  fi

  if [ "$TEAMCITY_PID_FILE_PATH" = "" ]; then
    TEAMCITY_PID_FILE_PATH="../logs/teamcity.pid"
  fi

  export CATALINA_PID="$TEAMCITY_PID_FILE_PATH"

  # unset environment variable because catalina.sh will create necessary file
  unset TEAMCITY_PID_FILE_PATH

  ./catalina.sh "$@"

  cd "$old_cwd"

;;
*)
  echo "Usage: teamcity-server.sh ( commands ... )"
  echo "commands:"
  echo "  run               Start TeamCity in the current window"
  echo "  start             Start TeamCity in a separate window"
  echo "  stop              Stop TeamCity, wait up to 5 seconds for the process to end"
  echo "  stop n            Stop TeamCity, wait up to n seconds for the process to end"
  echo "  stop n -force     Stop TeamCity, wait up to n seconds and then kill process if still running"
  exit 1
;;
esac
