
unless (node['teamcity']['agent']['user_password'] && node['teamcity']['agent']['user_token'])
  raise "You muss pass in node['teamcity']['agent']['user_password' and node['teamcity']['agent']['user_token']"
end

directory('/opt/jetbrains/TeamCity') { recursive true }

group 'teamcity' do
  gid 15000
  not_if "grep -q 'teamcity:' /etc/group"
end

user 'teamcity' do
  uid 15000
  gid 15000
  manage_home true
  home '/opt/jetbrains/TeamCity'
  shell '/bin/bash'
  password node['teamcity']['agent']['user_password']
  not_if "id teamcity"
end

file '/etc/kcpassword' do
  content Base64.decode64(node['teamcity']['agent']['user_token'])
  sensitive true
  mode 0600
end

execute 'auto_login' do
  command 'defaults write /Library/Preferences/com.apple.loginwindow autoLoginUser teamcity'
  not_if 'defaults read /Library/Preferences/com.apple.loginwindow autoLoginUser | egrep -q "^teamcity$"'
end

directory '/opt/jetbrains/TeamCity' do
  mode 0700
  owner 'teamcity'
  group 'teamcity'
end

directory '/opt/jetbrains/packages'

directory '/opt/jetbrains/TeamCity_agent' do
  mode 0755
  owner 'teamcity'
  group 'teamcity'
end

directory '/opt/jetbrains/TeamCity_agent/logs' do
  mode 0755
  owner 'teamcity'
  group 'teamcity'
end

# Removing the remote_file call for MacOS since the Mac agents don't have access to
# the generic packages s3 bucket. We will need to place the TeamCity agent package
# in the correct folder in our base agent image.

# remote_file "/opt/jetbrains/packages/#{File.basename(node['teamcity']['packages']['agent']['url'])}" do
#   source node['teamcity']['packages']['agent']['url']
#   checksum node['teamcity']['packages']['agent']['checksum']
# end

execute 'load_service' do
  command '/opt/jetbrains/TeamCity_agent/bin/mac.launchd.sh load'
  ignore_failure true
  user 'teamcity'
  action :nothing
  notifies :request_reboot, 'reboot[app_requires_reboot]', :delayed
end

execute 'extract_agent' do
  command "unzip /opt/jetbrains/packages/#{File.basename(node['teamcity']['packages']['agent']['s3']['key'])} && chown -R teamcity:teamcity /opt/jetbrains/TeamCity_agent"
  cwd '/opt/jetbrains/TeamCity_agent'
  not_if { File.exist?('/opt/jetbrains/TeamCity_agent/bin/agent.sh') }
  notifies :run, 'execute[load_service]', :immediately
end

directory '/opt/jetbrains/TeamCity/Library' do
  owner 'teamcity'
  group 'teamcity'
  recursive true
end

directory '/opt/jetbrains/TeamCity/Library/LaunchAgents' do
  owner 'teamcity'
  group 'teamcity'
  recursive true
end

cookbook_file '/opt/jetbrains/TeamCity/Library/LaunchAgents/jetbrains.teamcity.BuildAgent.plist' do
  owner 'teamcity'
  group 'teamcity'
  source 'jetbrains.teamcity.BuildAgent.plist'
  mode 0644
end

ruby_block 'read existing token from agent configuration' do
  block do
    begin
      current_conf = ::File.read('/opt/jetbrains/TeamCity_agent/conf/buildAgent.properties')
      node.override['teamcity']['agent']['token'] = current_conf.match(/^authorizationToken=(.*)$/)[1]
    rescue
    end
  end
end

template '/opt/jetbrains/TeamCity_agent/conf/buildAgent.properties' do
  source 'buildAgent.properties.erb'
  mode 0600
  owner 'teamcity'
  group 'teamcity'

  helper(:server_uri) { node['teamcity']['agent']['server_uri'] }
  helper(:name) { node['hostname'] }
  helper(:work_dir) { node['teamcity']['agent']['work_dir'] }
  helper(:temp_dir) { node['teamcity']['agent']['temp_dir'] }
  helper(:system_dir) { node['teamcity']['agent']['system_dir'] }
  helper(:own_port) { node['teamcity']['agent']['own_port'] }
  helper(:authorization_token) { node['teamcity']['agent']['token'] }
  helper(:system_properties) { node['teamcity']['agent']['system_properties'] }
  helper(:env_properties) { node['teamcity']['agent']['env_properties'] }
  notifies :run, 'execute[restart_service]', :delayed

end

execute 'restart_service' do
  command "su - teamcity -c 'launchctl stop jetbrains.teamcity.BuildAgent && launchctl start jetbrains.teamcity.BuildAgent'"
  ignore_failure true
  action :nothing
end

reboot 'app_requires_reboot' do
  action :nothing
  reason 'Reboot After TeamCity install'
  delay_mins 5
end
