s3_file "/opt/jetbrains/packages/#{File.basename(node['teamcity']['packages']['agent']['s3']['key'])}" do
  key node['teamcity']['packages']['agent']['s3']['key']
  checksum node['teamcity']['packages']['agent']['checksum']
  not_if { File.exist? "/opt/jetbrains/packages/#{File.basename(node['teamcity']['packages']['agent']['s3']['key'])}" }
end

powershell_script 'extract_agent' do
  code "unzip.exe /opt/jetbrains/packages/#{File.basename(node['teamcity']['packages']['agent']['s3']['key'])}"
  cwd '/opt/jetbrains/TeamCity_agent'
  not_if { File.exist?('/opt/jetbrains/TeamCity_agent/bin/agent.bat') }
end

ruby_block 'read existing token from agent configuration' do
  block do
    begin
      current_conf = ::File.read('/opt/jetbrains/TeamCity_agent/conf/buildAgent.properties')
      node.override['teamcity']['agent']['token'] = current_conf.match(/^authorizationToken=(.*)$/)[1]
    rescue
    end
  end
end

if node['teamcity']['agent']['user_password']

  s3_file "#{Chef::Config['file_cache_path']}/subinacl.msi" do
    key node['teamcity']['packages']['subinacl']['s3']['key']
    checksum node['teamcity']['packages']['subinacl']['checksum']
    not_if { File.exist? 'C:\Program Files (x86)\Windows Resource Kits\Tools\subinacl.exe' }
  end

  windows_package 'Windows Resource Kit Tools - SubInAcl.msi' do
    source "#{Chef::Config['file_cache_path']}/subinacl.msi"
    checksum node['teamcity']['packages']['subinacl']['checksum']
    installer_type :custom
    options '/Qn'
    action :nothing
    subscribes :install, "s3_file[#{Chef::Config['file_cache_path']}/subinacl.msi]", :immediately
  end

  target_user = 'teamcity'

  user "teamcity" do
    home 'C:\\Users\\teamcity'
    manage_home true
    password node['teamcity']['agent']['user_password']
  end

  ruby_block "Give #{target_user} SeBatchLogonRight right" do
    block { Chef::ReservedNames::Win32::Security.add_account_right(target_user, 'SeBatchLogonRight') }
    action :run
    not_if { Chef::ReservedNames::Win32::Security.get_account_right(target_user).include?('SeBatchLogonRight') }
  end

  ruby_block "Give #{target_user} SeSystemProfilePrivilege right" do
    block { Chef::ReservedNames::Win32::Security.add_account_right(target_user, 'SeSystemProfilePrivilege') }
    action :run
    not_if { Chef::ReservedNames::Win32::Security.get_account_right(target_user).include?('SeSystemProfilePrivilege') }
  end

  ruby_block "Give #{target_user} SeDebugPrivilege right" do
    block { Chef::ReservedNames::Win32::Security.add_account_right(target_user, 'SeDebugPrivilege') }
    action :run
    not_if { Chef::ReservedNames::Win32::Security.get_account_right(target_user).include?('SeDebugPrivilege') }
  end

  ruby_block "Give #{target_user} SeShutdownPrivilege right" do
    block { Chef::ReservedNames::Win32::Security.add_account_right(target_user, 'SeShutdownPrivilege') }
    action :run
    not_if { Chef::ReservedNames::Win32::Security.get_account_right(target_user).include?('SeShutdownPrivilege') }
  end

  ruby_block "Give #{target_user} SeProfileSingleProcessPrivilege right" do
    block { Chef::ReservedNames::Win32::Security.add_account_right(target_user, 'SeProfileSingleProcessPrivilege') }
    action :run
    not_if { Chef::ReservedNames::Win32::Security.get_account_right(target_user).include?('SeProfileSingleProcessPrivilege') }
  end

  ruby_block "Give #{target_user} SeServiceLogonRight right" do
    block { Chef::ReservedNames::Win32::Security.add_account_right(target_user, 'SeServiceLogonRight') }
    action :run
    not_if { Chef::ReservedNames::Win32::Security.get_account_right(target_user).include?('SeServiceLogonRight') }
    notifies :reboot_now, 'reboot[reboot_after_rights_change]', :immediately
  end

  windows_home 'teamcity' do
    password node['teamcity']['agent']['user_password']
  end

  group "Performance Monitor Users" do
    action :modify
    members "teamcity"
    append true
  end

  group "Administrators" do
    action :modify
    members "teamcity"
    append true
  end

  template '/opt/jetbrains/TeamCity_agent/launcher/conf/wrapper.conf' do
    source 'wrapper.conf.erb'
    helper(:teamcity_user) { '.\\teamcity' }
    helper(:teamcity_password) { node['teamcity']['agent']['user_password'] }
  end
end

template '/opt/jetbrains/TeamCity_agent/conf/buildAgent.properties' do
  source 'buildAgent.properties.erb'

  helper(:server_uri) { node['teamcity']['agent']['server_uri'] }
  helper(:name) { node['hostname'] }
  helper(:work_dir) { node['teamcity']['agent']['work_dir'] }
  helper(:temp_dir) { node['teamcity']['agent']['temp_dir'] }
  helper(:system_dir) { node['teamcity']['agent']['system_dir'] }
  helper(:own_port) { node['teamcity']['agent']['own_port'] }
  helper(:authorization_token) { node['teamcity']['agent']['token'] }
  helper(:system_properties) { node['teamcity']['agent']['system_properties'] }
  helper(:env_properties) { node['teamcity']['agent']['env_properties'] }

  notifies :restart, 'service[TCBuildAgent]', :delayed
end

execute 'install teamcity service' do
  command '/opt/jetbrains/TeamCity_agent/bin/service.install.bat'
  action :run
  cwd '/opt/jetbrains/TeamCity_agent/bin'
  not_if { ::Win32::Service.exists?('TCBuildAgent') }
end

# execute 'teamcity_acl' do
#   command '"C:\\Program Files (x86)\\Windows Resource Kits\\Tools\\subinacl.exe" /service TCBuildAgent /grant=teamcity=PTO'
# end if node['teamcity']['agent']['user_password']

service 'TCBuildAgent' do
  run_as_user '.\\teamcity' if node['teamcity']['agent']['user_password']
  run_as_password node['teamcity']['agent']['user_password'] if node['teamcity']['agent']['user_password']
  supports start: true, stop: true, restart: true, status: true
  action [:enable, :start]
end

reboot 'reboot_after_rights_change' do
  action :nothing
end

