include_recipe "#{cookbook_name}::default"

s3_file "/opt/jetbrains/packages/#{File.basename(node['teamcity']['packages']['server']['s3']['key'])}" do
  key node['teamcity']['packages']['server']['s3']['key']
  checksum node['teamcity']['packages']['server']['checksum']
  not_if { File.exist? "/opt/jetbrains/packages/#{File.basename(node['teamcity']['packages']['server']['s3']['key'])}" }
end

execute 'extract_teamcity_server' do
  command "tar xvf /opt/jetbrains/packages/#{File.basename(node['teamcity']['packages']['server']['s3']['key'])} && chown -R teamcity:teamcity /opt/jetbrains/TeamCity"
  cwd '/opt/jetbrains'
  not_if { File.exists?( "/opt/jetbrains/TeamCity/bin/version.sh" ) }
end

directory '/opt/jetbrains/TeamCity_data' do
  mode 0700
  owner 'teamcity'
  group 'teamcity'
end

directory '/opt/jetbrains/TeamCity_data/lib/jdbc' do
  mode 0700
  owner 'teamcity'
  group 'teamcity'
  recursive true
end

s3_file "/opt/jetbrains/TeamCity_data/lib/jdbc/#{File.basename(node['teamcity']['packages']['jdbc']['s3']['key'])}" do
  key node['teamcity']['packages']['jdbc']['s3']['key']
  checksum node['teamcity']['packages']['jdbc']['checksum']
  mode 0644
  owner 'teamcity'
  group 'teamcity'
  not_if { File.exist? "/opt/jetbrains/TeamCity_data/lib/jdbc/#{File.basename(node['teamcity']['packages']['jdbc']['s3']['key'])}" }
end

directory '/opt/jetbrains/TeamCity_data/plugins' do
  mode 0700
  owner 'teamcity'
  group 'teamcity'
  recursive true
end

s3_file "/opt/jetbrains/TeamCity_data/plugins/#{File.basename(node['teamcity']['packages']['oauth_plugin']['s3']['key'])}" do
  key node['teamcity']['packages']['oauth_plugin']['s3']['key']
  checksum node['teamcity']['packages']['oauth_plugin']['checksum']
  mode 0644
  owner 'teamcity'
  group 'teamcity'
  not_if { File.exist? "/opt/jetbrains/TeamCity_data/plugins/#{File.basename(node['teamcity']['packages']['oauth_plugin']['s3']['key'])}" }
end

s3_file "/opt/jetbrains/TeamCity_data/plugins/#{File.basename(node['teamcity']['packages']['ghe_hook_plugin']['s3']['key'])}" do
  key node['teamcity']['packages']['ghe_hook_plugin']['s3']['key']
  checksum node['teamcity']['packages']['ghe_hook_plugin']['checksum']
  mode 0644
  owner 'teamcity'
  group 'teamcity'
  not_if { File.exist? "/opt/jetbrains/TeamCity_data/plugins/#{File.basename(node['teamcity']['packages']['ghe_hook_plugin']['s3']['key'])}" }
end

s3_file "/opt/jetbrains/TeamCity_data/plugins/#{File.basename(node['teamcity']['packages']['saucelabs_plugin']['s3']['key'])}" do
  key node['teamcity']['packages']['saucelabs_plugin']['s3']['key']
  checksum node['teamcity']['packages']['saucelabs_plugin']['checksum']
  mode 0644
  owner 'teamcity'
  group 'teamcity'
  not_if { File.exist? "/opt/jetbrains/TeamCity_data/plugins/#{File.basename(node['teamcity']['packages']['saucelabs_plugin']['s3']['key'])}" }
end

s3_file "/opt/jetbrains/TeamCity_data/plugins/#{File.basename(node['teamcity']['packages']['merge_pull_request']['s3']['key'])}" do
  key node['teamcity']['packages']['merge_pull_request']['s3']['key']
  checksum node['teamcity']['packages']['merge_pull_request']['checksum']
  mode 0644
  owner 'teamcity'
  group 'teamcity'
  not_if { File.exist? "/opt/jetbrains/TeamCity_data/plugins/#{File.basename(node['teamcity']['packages']['merge_pull_request']['s3']['key'])}" }
end

cookbook_file '/opt/jetbrains/TeamCity/conf/server.xml' do
  source 'server.xml'
  mode 0600
  owner 'teamcity'
  group 'teamcity'
end

cookbook_file '/opt/jetbrains/TeamCity/bin/teamcity-server.sh' do
  source 'teamcity-server.sh'
  mode 0700
  owner 'teamcity'
  group 'teamcity'
end

cookbook_file '/etc/systemd/system/teamcity.service' do
  source 'teamcity.service'
  mode 0700
end

# cookbook_file '/etc/init.d/teamcity' do
#   source 'server_init.sh'
#   mode 0700
# end

service 'teamcity' do
  action [:enable, :start]
end

package 'nginx'

template '/etc/nginx/nginx.conf' do
  source 'teamcity-nginx.erb'
end

service 'nginx' do
  supports :status => true, :restart => true, :reload => true
  action [:enable, :start]
end
