#
# Cookbook:: sds_testrail
# Recipe:: default
#
# Copyright:: 2017, Twitch, All Rights Reserved.
include_recipe 'apt'

package 'nginx'

template '/etc/nginx/nginx.conf' do
  source 'testrail-nginx.conf.erb'
end

service 'nginx' do
  supports :status => true, :restart => true, :reload => true
  action [:enable, :start]
end

include_recipe 'php'
include_recipe 'php-fpm'

%w( php7.0-mysql php7.0-curl php7.0-json php7.0-mbstring php7.0-ldap php7.0-zip ).each do |php_package|
  package php_package
end

if node['testrail']['ioncube']['download']
  remote_file node['testrail']['ioncube']['location'] do
    source node['testrail']['ioncube']['download_url']
    mode "0644"
    action :create_if_missing
    notifies :run, "script[extract_ioncube_php]", :immediately
  end
end

script "extract_ioncube_php" do
  interpreter "bash"
  user "root"
  cwd File.dirname(node['testrail']['ioncube']['location'])
  action :nothing
  code <<-EOH
    tar xvfz #{File.basename(node['testrail']['ioncube']['location'])}
    mv ioncube /usr/local
    chown -R root:root /usr/local/ioncube
  EOH
end

ruby_block "determine php version" do
  block do
    Chef::Resource::RubyBlock.send(:include, Chef::Mixin::ShellOut)
    php_version_output = shell_out('php --version').run_command.stdout
    php_version = php_version_output.match(/PHP ([0-9]+\.[0-9]+)\.[0-9]+/)[1]
    Chef::Log.info("detected PHP version #{php_version}")
    ioncube_file_resource = run_context.resource_collection.find(:file => "#{run_context.node['php']['ext_conf_dir']}/ioncube.ini")
    ioncube_file_resource.content "; priority=00\nzend_extension=/usr/local/ioncube/ioncube_loader_lin_" + php_version + ".so\n"
  end
  only_if { run_context.node['testrail']['ioncube']['version'] == '' }
end

file "#{node['php']['ext_conf_dir']}/ioncube.ini" do
  content "; priority=00\nzend_extension=/usr/local/ioncube/ioncube_loader_lin_" + run_context.node['testrail']['ioncube']['version'] + ".so\n"
  owner "root"
  group "root"
  mode "0644"
  action :create
  notifies :run, 'script[enable ioncube]'
  notifies :restart, 'service[php-fpm]'
end

script 'enable ioncube' do
  interpreter "bash"
  user "root"
  code '/usr/sbin/phpenmod ioncube'
  action :nothing
end

directory '/opt/testrail/shared' do
  recursive true
  owner 'www-data'
  group 'www-data'
end

%w(attachments reports logs).each do |tr_dir|
  directory "/opt/testrail/shared/#{tr_dir}" do
    recursive true
    owner 'www-data'
    group 'www-data'
  end
end
