// Continent Mapping
// From MaxMind
export class ContinentMapping {
  constructor(readonly country_code: string, readonly continent_code: string) { }

  public get continent(): string {
    switch (this.continent_code) {
      case 'AF':
        return 'Africa';
      case 'AS':
        return 'Asia';
      case 'EU':
        return 'Europe';
      case 'NA':
        return 'North America';
      case 'SA':
        return 'South America';
      case 'OC':
        return 'Oceania';
      case 'AN':
        return 'Antarctica';
      default:
        return `Unknown - ${this.continent_code}`;
    }
  }
}

export const continentMap: { [country_code: string]: ContinentMapping } = {};
const continentMappingData = require('./data/continent_mappings.csv')

for (let map of continentMappingData) {
  continentMap[map[0]] = new ContinentMapping(map[0], map[1])
}

// Country Names
// From MaxMind
export class CountryName {
  constructor(readonly country_code: string, readonly name: string) { }
}

export const countryNameMap: { [country_code: string]: CountryName } = {}
const countryNameData = require('./data/country_names.csv')

for (let country of countryNameData) {
  countryNameMap[country[0]] = new CountryName(country[0], country[1])
}

// Region Data
// From MaxMind
export class Region {
  constructor(readonly country_code: string, readonly region_code: string, readonly region_name: string) { }
}

export const regionMap: { [code: string]: Region } = {};
const regionData = require('./data/regions.csv');

for (let region of regionData) {
  regionMap[`${region[0]}:${region[1]}`] = new Region(region[0], region[1], region[2]);
}

// Territory Mapping
// From Mode.Ace: select * from analysis.benhuang_meta_country;
// Not used here anymore
export class TerritoryMapping {
  constructor(readonly country_code: string, readonly territory: string) { }
}

let getTerritoryByCountry = (map: any): string => {
  if (map[5] === "Latin America") return "Latin America"
  if (map[0] === 'Europe' && map[3] !== 'RU') return "Europe"

  switch(map[3]) {
    case "US": return "North America";
    case "CA": return "North America";
    case "JP": return "Japan";
    case "KR": return "Korea";
    case "RU": return "Russia";
    case "TW": return "Taiwan";
  }

  return "Other"
}

export const territoryMap: { [country_code: string]: TerritoryMapping } = {};
const territoryMappingData = require('./data/territory_mappings.csv')

for (let map of territoryMappingData) {
  territoryMap[map[3]] = new TerritoryMapping(map[3], getTerritoryByCountry(map));
}
