import { InfluxDB } from 'influx';

let params: any = {
  host: '127.0.0.1',
  port: 8086,
  schema: [],
  pool: {
    requestTimeout: 30000
  }
}

if (process.env.STAGE === 'default') {
  params = {
    host: 'influxdb.cpe.wtf',
    protocol: 'https',
    port: 8486,
    username: 'demeter',
    schema: [],
    pool: {
      requestTimeout: 60000
    }
  };
} else if (process.env.STAGE === 'shadow') {
  params = {
    host: '10.202.24.116',
    port: 8086,
    schema: [],
    pool: {
      requestTimeout: 60000
    }
  };
}

export const InfluxClient = (password?: string) => {

  if (password) {
    params.password = password;
  }

  return new InfluxDB(params);
};
