import { SpadeEventData } from "../../types/SpadeEventData";
import { InfluxFields, InfluxTags } from "../../types/influx";
import { SpadeDataPoint } from "../SpadeDataPoint";
import { continentMap, countryNameMap, regionMap } from "../../geo";

export class DesktopInstallCompleted extends SpadeDataPoint {

  duration: number;
  bundle_duration: number;
  dotnet_duration: number;
  network_duration: number;

  app_version: string;
  installer_version: string;

  constructor(fields: SpadeEventData) {
    super('desktop_app_install', fields);

    // Tags
    this.continent = continentMap[fields.client_country] ? continentMap[fields.client_country].continent : `Unknown Country Code: ${fields.client_country}`;
    this.country = countryNameMap[fields.client_country] ? countryNameMap[fields.client_country].name : `Unknown Country Code: ${fields.client_country}`;
    this.app_version = fields.app_version;
    this.installer_version = fields.installer_version;

    // Fields
    this.city = fields.client_city;
    this.region = regionMap[`${fields.client_country}:${fields.client_region}`] ? regionMap[`${fields.client_country}:${fields.client_region}`].region_name : '';
    this.duration = +fields.time_to_install;
    this.bundle_duration = +fields.time_to_install_bundle;
    this.dotnet_duration = +fields.time_to_install_dotnet;
    this.network_duration = +fields.time_to_install_network;

  }

  getFields(): InfluxFields {
    return {
      ...super.getFields(),
      city: this.city,
      region: this.region,
      duration: this.duration,
      bundle_duration: this.bundle_duration,
      dotnet_duration: this.dotnet_duration,
      network_duration: this.network_duration
    }
  }

  getTags(): InfluxTags {
    return {
      ...super.getTags(),
      continent: this.continent,
      country: this.country,
      app_version: this.app_version,
      installer_version: this.installer_version,
      duration_outlier: String(this.duration < 0 || this.duration > 120000)
    }
  }
}
