import { SpadeEventData } from "../../types/SpadeEventData";
import { InfluxFields, InfluxTags } from "../../types/influx";
import { SpadeDataPoint } from "../SpadeDataPoint";
import { continentMap, countryNameMap, regionMap } from "../../geo";

export class DesktopPageLoad extends SpadeDataPoint {

  duration: number;
  app_version: string;

  constructor(fields: SpadeEventData) {
    super('desktop_page_load', fields);

    // Tags
    this.continent = continentMap[fields.client_country] ? continentMap[fields.client_country].continent : `Unknown Country Code: ${fields.client_country}`;
    this.country = countryNameMap[fields.client_country] ? countryNameMap[fields.client_country].name : `Unknown Country Code: ${fields.client_country}`;
    this.app_version = fields.app_version;

    // Fields
    this.city = fields.client_city;
    this.region = regionMap[`${fields.client_country}:${fields.client_region}`] ? regionMap[`${fields.client_country}:${fields.client_region}`].region_name : '';
    this.duration = +fields.interact_time;
  }

  getFields(): InfluxFields {
    return {
      ...super.getFields(),
      city: this.city,
      region: this.region,
      duration: this.duration,
    }
  }

  getTags(): InfluxTags {
    return {
      ...super.getTags(),
      continent: this.continent,
      country: this.country,
      app_version: this.app_version,
      duration_outlier: String(this.duration < 0 || this.duration > 120000)
    }
  }
}
