import { SpadeEventData } from "../../types/SpadeEventData";
import { InfluxFields, InfluxTags } from "../../types/influx";
import { SpadeDataPoint } from "../SpadeDataPoint";
import { continentMap, countryNameMap, regionMap } from "../../geo";

export class DesktopVideoFirstFrame extends SpadeDataPoint {

  duration: number;
  channel_interact_time: number;
  video_ready_time: number;

  app_version: string;

  constructor(fields: SpadeEventData) {
    super('desktop_video_first_frame', fields);

    // Tags
    this.continent = continentMap[fields.client_country] ? continentMap[fields.client_country].continent : `Unknown Country Code: ${fields.client_country}`;
    this.country = countryNameMap[fields.client_country] ? countryNameMap[fields.client_country].name : `Unknown Country Code: ${fields.client_country}`;
    this.app_version = fields.app_version;

    // Fields
    this.city = fields.client_city;
    this.region = regionMap[`${fields.client_country}:${fields.client_region}`] ? regionMap[`${fields.client_country}:${fields.client_region}`].region_name : '';
    this.duration = +fields.first_frame_time;
    this.channel_interact_time = +fields.channel_interact_time;
    this.video_ready_time = +fields.video_ready_time;

  }

  getFields(): InfluxFields {
    return {
      ...super.getFields(),
      city: this.city,
      region: this.region,
      duration: this.duration,
      channel_interact_time: this.channel_interact_time,
      video_ready_time: this.video_ready_time
    }
  }

  getTags(): InfluxTags {
    return {
      ...super.getTags(),
      continent: this.continent,
      country: this.country,
      app_version: this.app_version,
      duration_outlier: String(this.duration < 0 || this.duration > 120000),
      channel_interact_time_outlier: String(this.channel_interact_time < 0 || this.duration > 120000),
      video_ready_time_outlier: String(this.video_ready_time < 0 || this.duration > 120000)
    }
  }
}
