import { SpadeEventData } from "../types/SpadeEventData";

import { InfluxTags, InfluxFields } from "../types/influx";
import { SpadeDataPoint } from './SpadeDataPoint';

export class MobileDataPoint extends SpadeDataPoint {

  latency_event: string;
  duration: number;
  cold_start: boolean;
  screen_name: string;
  sub_screen: string;
  platform: string;

  constructor(fields: SpadeEventData) {
    super('mobile_latency_event', fields);

    // Values
    this.duration = +fields.load_time;

    // Tags
    this.latency_event = fields.latency_event;
    this.screen_name = fields.screen_name;
    this.sub_screen = fields.sub_screen;
    this.cold_start = this.parseBool(fields.cold_start);
    this.platform = fields.platform;
    if (fields.cold_start === "0") this.cold_start = false
    if (fields.cold_start === "1") this.cold_start = true
  }

  getFields(): InfluxFields {
    return {
      duration: this.duration,
      ...super.getFields()
    }
  }

  getTags(): InfluxTags {
    return {
      latency_event: this.latency_event,
      screen_name: this.screen_name,
      sub_screen: this.sub_screen,
      cold_start: String(this.cold_start),
      duration_outlier: String(this.duration < 0 || this.duration > 120000),
      platform: this.platform,
      ...super.getTags()
    }
  }
}
