import { SpadeEventData } from "../types/SpadeEventData";

import { InfluxTags, InfluxFields } from "../types/influx";
import { SpadeDataPoint } from './SpadeDataPoint';

export class TwilightDataPoint extends SpadeDataPoint {

  build_id: string;
  client_app: string;
  destination: string;
  device_id: string;

  domain: string;
  logged_in: boolean;
  url: string;

  page_component_name: string;
  page_session_id: string;

  constructor(readonly measurement: string, fields: SpadeEventData) {
    super(measurement, fields);

    // Tags
    this.client_app = fields.client_app;
    this.domain = this.parseDomain(fields.domain);
    this.logged_in = this.parseBool(fields.logged_in);
    this.page_component_name = fields.page_component_name;
    this.destination = fields.destination;

    // Values
    this.build_id = fields.app_version;
    this.url = this.parseURL(fields.url);
    this.page_session_id = fields.page_session_id;
  }

  getFields(): InfluxFields {
    return {
      url: this.url,
      page_session_id: this.page_session_id,
      ...super.getFields()
    }
  }

  getTags(): InfluxTags {
    return {
      build_id: this.build_id,
      client_app: this.client_app,
      domain: this.domain,
      logged_in: String(this.logged_in),
      page_component_name: this.page_component_name,
      destination: this.destination,
      ...super.getTags()
    }
  }
}
