import { SpadeDataPoint } from "../SpadeDataPoint";
import { SpadeEventData } from "../../types/SpadeEventData";
import { InfluxFields, InfluxTags } from "../../types/influx";

export class APIQuery extends SpadeDataPoint {
  // Tags
  is_pre_pageload: boolean;
  query_name: string;

  // Fields
  client_time: number;
  execution_time: number;
  request_time: number;
  relative_start_time: number;

  constructor(fields: SpadeEventData) {
    super('api_query', fields);

    this.client_time = (new Date(fields.client_time_utc)).getTime() / 1000;
    this.is_pre_pageload = this.parseBool(fields.is_pre_pageload);
    this.query_name = fields.query_name;

    this.execution_time = +fields.execution_time;
    this.request_time = +fields.request_time;

    if (fields.hasOwnProperty('relative_start_time')) {
      this.relative_start_time = +fields.relative_start_time;
    } else {
      this.relative_start_time = 0;
    }
  }

  getFields(): InfluxFields {
    return {
      count: 1,
      execution_time: this.execution_time,
      request_time: this.request_time,
      client_time: this.client_time,
      relative_start_time: this.relative_start_time,
      ...super.getFields()
    }
  }

  getTags(): InfluxTags {
    return {
      is_pre_pageload: String(this.is_pre_pageload),
      query_name: this.query_name,
      ...super.getTags()
    }
  }
}
