import { BenchmarkDataPoint } from "./BenchmarkDataPoint";
import { SpadeEventData } from "../../types/SpadeEventData";
import { InfluxTags } from "../../types/influx";

export class BenchmarkCompleteTransition extends BenchmarkDataPoint {

  //and left(url, 29) != 'https://clips.twitch.tv/embed'

  // Tags
  is_app_launch: boolean;
  lost_visibility: boolean;

  constructor(fields: SpadeEventData) {
    super('complete_transition', fields);

    this.is_app_launch = this.parseBool(fields.is_app_launch);
    this.lost_visibility = this.parseBool(fields.lost_visibility);
  }

  getTags(): InfluxTags {
    return {
      is_app_launch: String(this.is_app_launch),
      lost_visibility: String(this.lost_visibility),
      ...super.getTags()
    }
  }
}
