import { BenchmarkDataPoint } from "./BenchmarkDataPoint";
import { SpadeEventData } from "../../types/SpadeEventData";
import { InfluxTags, InfluxFields } from "../../types/influx";

export class BenchmarkComponentInteractive extends BenchmarkDataPoint {

  // Tags
  is_pre_pageload: boolean;
  component: string;

  // Fields
  component_id: number;
  parent_component_id: number;
  relative_start_time: number;
  relative_complete_time: number;

  constructor(fields: SpadeEventData) {
    super('component_interactive', fields);

    this.component = fields.component;
    this.component_id = +fields.component_id;
    this.parent_component_id = +fields.parent_component_id;

    this.is_pre_pageload = this.parseBool(fields.is_pre_pageload);

    if (fields.hasOwnProperty('duration')) {
      this.duration = +fields.duration;
    } else if (fields.hasOwnProperty('time_from_initializing')) {
      this.duration = +fields.time_from_initializing * 1000;
    } else {
      this.duration = -1;
    }

    if (fields.hasOwnProperty('relative_start_time')) {
      this.relative_start_time = +fields.relative_start_time;
      this.relative_complete_time = this.duration + this.relative_start_time;
    } else {
      this.relative_start_time = 0;
      this.relative_complete_time = 0;
    }
  }

  getTags(): InfluxTags {
    return {
      component: this.component,
      is_pre_pageload: String(this.is_pre_pageload),
      ...super.getTags()
    }
  }

  getFields(): InfluxFields {
    return {
      component_id: this.component_id,
      parent_component_id: this.parent_component_id,
      relative_start_time: this.relative_start_time,
      relative_complete_time: this.relative_complete_time,
      ...super.getFields()
    }
  }
}
