import { SpadeEventData } from "../../types/SpadeEventData";
import { InfluxFields, InfluxTags } from "../../types/influx";
import { TwilightDataPoint } from "../TwilightDataPoint";

export class BenchmarkCustomEvent extends TwilightDataPoint {

  duration: number;
  key: string;
  is_app_launch: boolean;
  lost_visibility: boolean;

  constructor(fields: SpadeEventData) {
    super(`custom_event`, fields);
    this.duration = +fields.duration;
    this.key = fields.key;
    this.is_app_launch = this.parseBool(fields.is_app_launch);
    this.lost_visibility = this.parseBool(fields.lost_visibility);
  }

  getFields(): InfluxFields {
    return {
      duration: this.duration,
      ...super.getFields()
    }
  }

  getTags(): InfluxTags {
    return {
      key: this.key,
      is_app_launch: String(this.is_app_launch),
      duration_outlier: String(this.duration < 0 || this.duration > 120000),
      lost_visibility: String(this.lost_visibility),
      ...super.getTags()
    }
  }
}
