import { SpadeEventData } from "../../types/SpadeEventData";
import { InfluxFields, InfluxTags } from "../../types/influx";
import { TwilightDataPoint } from "../TwilightDataPoint";

export class BenchmarkDataPoint extends TwilightDataPoint {
  // Fields
  duration: number;

  constructor(measurement: string, fields: SpadeEventData) {
    super(measurement, fields);

    this.duration = +fields.time_from_fetch;
  }

  getFields(): InfluxFields {
    return {
      duration: this.duration,
      ...super.getFields()
    }
  }

  getTags(): InfluxTags {
    return {
      duration_outlier: String(this.duration < 0 || this.duration > 120000),
      ...super.getTags()
    }
  }
}
