import { SpadeEventData } from "../../types/SpadeEventData";
import { InfluxFields, InfluxTags } from "../../types/influx";
import { TwilightDataPoint } from "../TwilightDataPoint";

export class Pageview extends TwilightDataPoint {

  constructor(fields: SpadeEventData) {
    super('pageview', fields);

    // unique logic for determining this field.
    this.logged_in = parseInt(fields.user_id) > 0;
  }

  getFields(): InfluxFields {
    return {
      count: 1,
      ...super.getFields()
    }
  }

  getTags(): InfluxTags {
    return {
      ...super.getTags()
    }
  }
}
