var path = require('path');
var serverlessWebpack = require('serverless-webpack')
var webpackNodeExternals = require('webpack-node-externals')

module.exports = {
  entry: serverlessWebpack.lib.entries,
  target: 'node',
  mode: 'production',
  module: {
    rules: [
      { test: /\.ts(x?)$/, loader: 'ts-loader' },
      { test: /\.csv$/, loader: 'csv-loader' }
    ]
  },
  externals: [webpackNodeExternals()],
  resolve: {
    extensions: ['.ts', '.js', '.tsx', '.jsx']
  },
  output: {
    libraryTarget: 'commonjs',
    path: path.join(__dirname, '.webpack'),
    filename: 'handler.js'
  },
};
