# frozen_string_literal: true

require 'aws-sdk-sns'

module Abaci
  class << self

    STATUS_MAP = {
      ok: 0,
      warning: 1,
      critical: 2,
      unknown: 3
    }

    def notify_sensu(status, message = nil)
      epoch = config[:started_at]

      message = {
        client: 'abaci-cli',
        check: {
          name: 'abaci-status',
          issued: epoch,
          executed: epoch,
          timestamp: epoch,
          status: STATUS_MAP[status] || 3,
          ttl: 10 * 60,
          ttl_status: 2,
          occurences: 10,
          output: "Abaci CLI Status: #{message || status}",
          handlers: ['pagerduty-ipdel'],
          pager_team: 'work_hours'
        }
      }

      attributes = {
        pipe: { data_type: 'String', string_value: 'results' },
        type: { data_type: 'String', string_value: 'direct' }
      }

      sns_client.publish target_arn: config[:sensu_sns], message: message.to_json, message_attributes: attributes
    end

    def sns_client
      @sns_client ||= Aws::SNS::Client.new profile: config[:aws_profile], region: config[:sensu_region], retry_limit: 5
    end
  end
end
