package patches.vcsRoots

import jetbrains.buildServer.configs.kotlin.v2018_2.*
import jetbrains.buildServer.configs.kotlin.v2018_2.ui.*
import jetbrains.buildServer.configs.kotlin.v2018_2.vcs.GitVcsRoot

/*
This patch script was generated by TeamCity on settings change in UI.
To apply the patch, change the vcsRoot with id = 'ProjectSourceRoot'
accordingly, and delete the patch script.
*/
changeVcsRoot(RelativeId("ProjectSourceRoot")) {
    val expected = GitVcsRoot({
        id("ProjectSourceRoot")
        name = "Project Source"
        url = "git@git-aws.internal.justin.tv:CPE-Ops/alpine-dumb-init.git"
        branch = "%git.branch.default%"
        branchSpec = "%git.branch.spec%"
        useTagsAsBranches = true
        authMethod = uploadedKey {
            uploadedKey = "id_rsa_teamcity"
        }
    })

    check(this == expected) {
        "Unexpected VCS root settings"
    }

    (this as GitVcsRoot).apply {
        url = "git@git.xarth.tv:CPE-Ops/alpine-dumb-init.git"
    }

}
