# frozen_string_literal: true

lib = File.expand_path('../lib', __FILE__)
$LOAD_PATH.unshift(lib) unless $LOAD_PATH.include?(lib)

require 'arcana/version'

Gem::Specification.new do |spec|
  # protect against an accidental release
  raise 'RubyGems 2.0 or newer is required to protect against public gem pushes.' unless spec.respond_to?(:metadata)
  spec.metadata['allowed_push_host'] = 'https://gem.pkgs.xarth.tv'

  spec.name          = 'arcana'
  spec.version       = Arcana::VERSION
  spec.authors       = ['Trey Briggs', 'Bryan McLemore']
  spec.email         = ['tbriggs@justin.tv']

  spec.summary       = 'Arcana library for Ruby'
  spec.description   = 'Secret Management using S3/KMS and Litany Service IDs'
  spec.homepage      = 'https://git-aws.internal.justin.tv/CPE-Ops/arcana'

  spec.files         = `git ls-files -z`.split("\x0").reject { |f| f.match '^(bin|exe|test)' }
  spec.bindir        = 'exe'
  spec.executables   = ['arcana']
  spec.require_paths = ['lib']

  spec.add_dependency 'aws-sdk-kms', '~> 1.6'
  spec.add_dependency 'aws-sdk-s3', '~> 1.13'
  spec.add_dependency 'clamp', '~> 1.2'

  spec.add_development_dependency 'bundler', '~> 1.16'
  spec.add_development_dependency 'geminabox-release', '~> 1.2'
  spec.add_development_dependency 'pry', '~> 0.10'
  spec.add_development_dependency 'rake', '~> 12.3'
  spec.add_development_dependency 'rubocop', '~> 0.57'
  spec.add_development_dependency 'yard', ' ~> 0'
end
