# frozen_string_literal: true

require 'clamp'

require 'arcana/version'
require 'arcana/cli/decrypt'
require 'arcana/cli/encrypt'
require 'arcana/cli/recrypt'

module Arcana
  module CLI
    class Runner < Clamp::Command
      subcommand 'decrypt', 'Decrypts a given piece of data.', Decrypt
      subcommand 'encrypt', 'Encrypts a given piece of data.', Encrypt
      subcommand 'recrypt', 'Re-Encrypts a given material from one key to another.', Recrypt

      option '--version', :flag, 'Shows the version.' do
        puts Arcana::VERSION
        exit(0)
      end
    end
  end
end
