# frozen_string_literal: true

require 'arcana/cli/base'

module Arcana
  module CLI
    class Encrypt < Arcana::CLI::Base

      option ['-d', '--data'], 'SECRET DATA', 'The raw data to store in Arcana', default: nil
      option ['-f', '--file'], 'FILE PATH', 'A path to a file you wish to store in Arcana', default: nil

      def execute
        to_store = (file && File.read(file)) || data || ($stdin.ready? && $stdin.read)

        unless to_store
          puts 'Unable to find data to store in Arcana. Please provide either the data flag, file flag, or provide data to stdin.'
          exit(1)
        end

        arcana_client.encrypt(material_name, data: to_store)
        puts 'Successfully stored secret!'
      end
    end
  end
end