module Arcana
  class << self

    # Returns the AWS region id for the combination of a target and service id
    # @return [String]
    def region_id(target, service_id)
      target ||= service_id.split('-').last

      return nil unless standard_region_mapping.key?(target.to_sym) || standard_region_mapping.value?(target)

      standard_region_mapping.fetch(target.to_sym, target)
    end

    # Returns the standard airport code to aws region mappings used by CSI
    # @return [Hash<Symbol, String>]
    def standard_region_mapping
      @standard_region_mapping ||= {
        bom: 'ap-south-1',
        cdg: 'eu-west-3',
        cle: 'us-east-2',
        dub: 'eu-west-1',
        fra: 'eu-central-1',
        gru: 'sa-east-1',
        iad: 'us-east-1',
        icn: 'ap-northeast-2',
        lhr: 'eu-west-2',
        nrt: 'ap-northeast-1',
        pdx: 'us-west-2',
        sin: 'ap-southeast-1',
        sjc: 'us-west-1',
        syd: 'ap-southeast-2',
        yul: 'ca-central-1'
      }
    end
  end
end