package patches.buildTypes

import jetbrains.buildServer.configs.kotlin.v2018_1.*
import jetbrains.buildServer.configs.kotlin.v2018_1.buildFeatures.commitStatusPublisher
import jetbrains.buildServer.configs.kotlin.v2018_1.buildFeatures.notifications
import jetbrains.buildServer.configs.kotlin.v2018_1.buildSteps.dockerCompose
import jetbrains.buildServer.configs.kotlin.v2018_1.buildSteps.script
import jetbrains.buildServer.configs.kotlin.v2018_1.ui.*

/*
This patch script was generated by TeamCity on settings change in UI.
To apply the patch, change the buildType with id = 'Master_Build'
accordingly, and delete the patch script.
*/
changeBuildType(RelativeId("Master_Build")) {
    check(artifactRules == "") {
        "Unexpected option value: artifactRules = $artifactRules"
    }
    artifactRules = "+:README.md=>artifact.tar.gz"

    params {
        add {
            password("bobsled.token", "credentialsJSON:76aaaf7a-0868-4276-9d87-6eb992f351f2", display = ParameterDisplay.HIDDEN)
        }
    }

    expectSteps {
    }
    steps {
        insert(0) {
            dockerCompose {
                name = "New build step"
                id = "RUNNER_312"
                file = "docker-compose.yml"
            }
        }
        insert(1) {
            script {
                id = "RUNNER_313"
                executionMode = BuildStep.ExecutionMode.RUN_ON_FAILURE
                scriptContent = "echo 1"
            }
        }
    }

    features {
        add {
            commitStatusPublisher {
                id = "BUILD_EXT_48"
                vcsRootExtId = "${DslContext.settingsRoot.id}"
                publisher = github {
                    githubUrl = "https://git.xarth.tv/api/v3"
                    authType = personalToken {
                        token = "credentialsJSON:988bb438-58fa-40be-b1b6-033251fcc814"
                    }
                }
                param("github_oauth_user", "thohanso")
            }
        }
        add {
            notifications {
                id = "BUILD_EXT_58"
                notifierSettings = slackNotifier {
                    connection = "PROJECT_EXT_150"
                    sendTo = "#teamcity-builds"
                    messageFormat = verboseMessageFormat {
                        addBranch = true
                        addChanges = true
                        addStatusText = true
                        maximumNumberOfChanges = 5
                    }
                }
                buildFailedToStart = true
                buildFailed = true
                buildFinishedSuccessfully = true
                buildProbablyHanging = true
            }
        }
    }

    requirements {
        add {
            moreThanVer("docker.version", "18.09.6", "RQ_61")
        }
    }
}
