# Mobile Web Monorepo

[![GitHub](https://img.shields.io/badge/-GitHub-24292e.svg?style=for-the-badge)](https://git-aws.internal.justin.tv/mobile-web/channel-lambda)
[![Wiki](https://img.shields.io/badge/-Wiki-4b367c.svg?style=for-the-badge)](https://wiki.twitch.com/display/ENG/Mobile+Web)
[![Architecture](https://img.shields.io/badge/-Architecture%20Documents-blue.svg?style=for-the-badge)](https://drive.google.com/drive/folders/1STYzY9VmxI01v8TUhYbKaPJYm6uUfhqV)
[![Analytics](https://img.shields.io/badge/-Mode%20Analytics-green.svg?style=for-the-badge)](https://modeanalytics.com/twitch/spaces/6405a1094dfe)
[![Jenkins](https://img.shields.io/badge/-Jenkins-yellow.svg?style=for-the-badge)](https://jenkins.internal.justin.tv/view/mobile-web/)
[![JIRA](https://img.shields.io/badge/-JIRA-orange.svg?style=for-the-badge)](https://jira.twitch.com/projects/MWC/summary)
[![Roadmap](https://img.shields.io/badge/-Roadmap-red.svg?style=for-the-badge)](https://wiki.twitch.com/display/ENG/Mobile+Web+Roadmap)

This is the mono repo for the mobile web codebase. This repo uses [lerna](https://github.com/lerna/lerna) and
[yarn](https://github.com/yarnpkg/yarn) workspaces to manage multiple projects relevant to mobile web.

## Table of Contents

* [Packages](#packages)
* [Getting Started](#getting-started)
  * [Installing Dependencies](#installing-dependencies)
  * [Configuring <em>/etc/hosts</em>](#configuring-etchosts)
    * [Localhost](#localhost)
    * [Staging](#staging)
* [Infrastructure](#infrastructure)
* [Accessing Logs](#accessing-logs)
* [Deploying the Site](#deploying-the-site)

## Packages

<dl>
  <dt>mobile-web :: <a href="/packages/mobile-web">Source</a> | <a href="https://git-aws.internal.justin.tv/pages/mobile-web/channel-lambda/packages/mobile-web/">Documentation</a></dt>
  <dd>Mobile web codebase that powers the mobile web client, lambda backend, and dev server.</dd>
</dl>

## Getting Started

### Installing Dependencies

Check out the repository and *source* the [firstTime](/scripts/firstTime) script to make sure that all necessary dependencies are installed. This script is idempotent, and it is occasionally useful to re-run to verify that no new dependencies are missing.

```
git clone https://git-aws.internal.justin.tv/mobile-web/channel-lambda.git
cd channel-lambda
source ./scripts/firstTime
```

Once complete, follow the instructions in the development package being worked on for additional setup. These include:
* [mobile-web](https://git-aws.internal.justin.tv/pages/mobile-web/channel-lambda/packages/mobile-web/) - The main codebase for m.twitch.tv.
* [mobile-web-tests](packages/mobile-web-tests/) - The python-based appium tests that run on devices in AWS Device Farm to verify user experience.

After a git pull that introduces a new package (or package changes), you'll need to run `yarn:build` from the root level of the repo to ensure that all packages are properly built for local use.

### Configuring _/etc/hosts_

#### Localhost

The development tooling assumes that the development server will be running at [localhost.m.twitch.tv:3003](http://localhost.m.twitch.tv:3003).

If this is not already accessible, add the following to _/etc/hosts_.

```
127.0.0.1  localhost.m.twitch.tv
```

#### Staging

[staging.m.twitch.tv](https://staging.m.twitch.tv) is only available from the _justin.tv_ network; however, the domain is an alias for a CloudFront instance and can be accessed by IP.

In order to reach the domain from the _wpa2_ network, add the following to _/etc/hosts_.

```
13.32.153.174  staging.m.twitch.tv
```

In addition to [staging.m.twitch.tv](https://staging.m.twitch.tv), there is a public staging site, [public.staging.m.twitch.tv](https://public.staging.m.twitch.tv), that can be used when access is necessary from outside the Amazon network. This should be used sparingly and should not be given to **_any_** outsiders.

## Infrastructure

The infrastructure is described in an [architecture document](https://docs.google.com/a/justin.tv/document/d/10eR2UpK-FL8wjgjgAGKiOubu47ZrQGgxmuTnThf0vPg/edit?usp=sharing).

## Accessing Logs

See the [deploy runbook](https://wiki.twitch.com/display/ENG/Deploy+Runbook#DeployRunbook-AccessingLogs)
for detailed instructions on how to access logs.

## Deploying the Site

See the [deploy runbook](https://wiki.twitch.com/display/ENG/Deploy+Runbook)
for detailed instructions on how to deploy to
[staging](https://staging.m.twitch.tv) or [production](https://m.twitch.tv).
