/* tslint:disable:no-namespace */

declare namespace Branch {
  type ClickedJourneyCTA = 'didClickJourneyCTA';
  type ClickedJourneyClose = 'didClickJourneyClose';
  type ClickedJourneyContinue = 'didClickJourneyContinue';
  type BranchJourneyEvent =
    | ClickedJourneyCTA
    | ClickedJourneyClose
    | ClickedJourneyContinue;

  type BranchJourneyListener = (
    event: BranchJourneyEvent,
    data?: object,
  ) => void;

  interface BranchOptions {
    no_journeys?: boolean;
  }

  interface BranchGlobal {
    init: (apiKey: string, options?: Branch.BranchOptions) => void;
    link: (
      linkData: object,
      callback: (err: any, url: string | undefined | null) => void,
    ) => void;
    setBranchViewData: (data: object) => void;
    track: (event: string, data?: object) => void;
    closeJourney: (callback?: (err: any) => void) => void;
    addListener: (listener: BranchJourneyListener) => void;
    removeListener: (listener: BranchJourneyListener) => void;
  }
}
