# Branch-io Package

Branch.io is a 3rd party service that helps us promote users to the native
mobile app via tracked links and dynamically displayed upsells. This package
exposes an abstraction layer on top of the Branch SDK that specifically works
with how we use Branch at Twitch.

To learn more about how Branch.io upsells work for us, see [this doc](https://docs.google.com/document/d/1wqHR_2mb_XA6feG_Gq_vFdV3_unyIZYYDIpt3S-Nza0)

# How to Use

1.  Initialize the client JS library: `initializeBranch(API_KEY, OPTIONS)`
2.  Add the `BranchUpsell` component on any page you want to trigger an upsell

```
<BranchUpsell
    delaySecondsUntilUpsell={5}
    journey={{
        type: BranchJourneyType.MainDir,
    }}
/>
```

3.  Add the `BranchTimedTracker` component on any page you want to send tracking
    events upstream to Branch.io

```
<BranchTimedTracker
    delaySecondsUntilTrack={5 * 60}
    event={BranchEvent.FiveMinutePlay}
/>
```

4.  If you need to create a deeplink URL but do not want to use an upsell,
    call `fetchBranchURL` to asynchronously generate a deeplink.
