# Tachyon Logger

The tachyon logger provides an extensible framework for logging to various sources and a clean way to inject mutators into the logging stream.

# Architecture

The logger package consists of an abstract logger that defines common logging methods. Each implementation of a logger
will have a serializer and some number of middleware pieces that can mutate a message before serialization that are guaranteed to run in a fixed order.

Furthermore, a `LogDispatcher` can be used to aggregate multiple loggers and dispatch to all of them for each message.

## Getting Started

### Installing Dependencies

Follow the instructions in the [base README](../../README.md#getting-started) for your first time. Subsequent updates should use
`lerna bootstrap` to udpate dependencies and `lerna add --scope=tachyon-logger <dependency> [--dev]` to add dependencies.

## Developing the Logger

Currently the logger is linked into `mobile-web` the first time you run `lerna bootstrap` (which is run by the first time script). Once this is done any changes to this package will propagate to the mobile web app every time you run `yarn build`. If you want changes to automatically propagate you can run `yarn build:watch` to keep updating with each change.

You can run tests via `yarn test` or `yarn test:wach` and you can run the full CI suite via `yarn ci`.
