import { Logger, LogMessage } from 'tachyon-logger/logger';

/**
 * A logger that will dispatch log messages to multiple loggers.
 */
export class LoggerDispatcher implements Logger {
  private loggers: Logger[];

  constructor(loggers: Logger[]) {
    this.loggers = loggers;
  }

  public register(log: Logger): void {
    this.loggers.push(log);
  }

  public setLoggers(loggers: Logger[]): void {
    this.loggers = loggers;
  }

  public debug(message: LogMessage): void {
    this.loggers.forEach(log => log.debug(message));
  }

  public log(message: LogMessage): void {
    this.loggers.forEach(log => log.log(message));
  }

  public info(message: LogMessage): void {
    this.loggers.forEach(log => log.info(message));
  }

  public warn(message: LogMessage): void {
    this.loggers.forEach(log => log.warn(message));
  }

  public error(message: LogMessage): void {
    this.loggers.forEach(log => log.error(message));
  }
}
