import { LogObject, LogOutput } from 'tachyon-logger/logger';

/**
 * Serializes the log object to the correct format. Iff window is defined, the
 * code should be returned as is for readability in the browser; otherwise, the
 * log should be stringified for CloudWatch.
 *
 * @param logObj The log object to serialize.
 */

export function JSONifySerializer(logObj: LogObject): LogOutput {
  if (typeof window !== 'undefined') {
    return logObj;
  }
  return JSON.stringify(logObj);
}
