/**
 * Temporarily replaces the console logging methods and returns the last set of
 * arguments passed to any console logging method after running a given function.
 *
 * @param func A test function to run after replacing the console logging methods.
 */

export function captureConsoleOutput(func: () => any): any[] {
  const logMethods = [
    console.debug,
    console.log,
    console.info,
    console.warn,
    console.error,
  ];
  let args: any[] = [];
  console.debug = console.log = console.info = console.warn = console.error = (
    message?: any,
    ...optionalParams: any[]
  ): void => {
    args = [message, ...optionalParams];
  };
  func();
  [
    console.debug,
    console.log,
    console.info,
    console.warn,
    console.error,
  ] = logMethods;
  return args;
}
