"""Configure AWS and Device Farm and run the tests."""

import ConfigParser
import os

import sys
from fwk.base.aws.aws_device_farm import AWSDeviceFarm

config = ConfigParser.RawConfigParser()
config.read('aws_config.cfg')
AWS_ID = config.get('device_farm', 'AWS_ACCESS_KEY')
AWS_KEY = config.get('device_farm', 'AWS_SECRET_KEY')
AWS_ARN = config.get('device_farm', 'DEVICE_FARM_ARN')
PROJECT_NAME = config.get('device_farm', 'PROJECT_NAME')
DEVICE_POOL_NAME = config.get('device_farm', 'DEVICE_POOL_NAME')
os.environ['test_results_folder'] = os.path.abspath(
    os.path.join(os.path.dirname(sys.modules['__main__'].__file__), 'output'))
device_farm = AWSDeviceFarm(AWS_ID, AWS_KEY, AWS_ARN)
device_farm.package_and_execute(PROJECT_NAME, DEVICE_POOL_NAME)
