"""Implements an object capable of controlling the events page."""
from fwk.base.locators import ByClass  # pylint: disable=import-error
from fwk.base.locators import ByCss  # pylint: disable=import-error
from fwk.base.base_page import BasePage  # pylint: disable=import-error


class EventsPage(BasePage):
    """Events Page."""

    #  Elements definition
    def __init__(self, driver):
        """Driver assignment to object."""
        self.driver = driver

    EVENT_CALENDAR_MONTH = ByCss('div.event-calendar__month span')
    EVENT_CALENDAR_DAY = ByCss('div.event-calendar__day span')
    BOX_ART = ByClass("card__layout")
    CHANNEL_LIST = ByClass('channel-list')
    TIMESTAMP = ByClass('timespan--date')
    CHANNEL_EVENT_INFO = ByCss('div.event-channel-info')
    CHANNEL_EVENT_INFO_LOGO = ByCss('div.event-channel-info img')
    GAME_EVENT_INFO = ByCss('div.event-game-info')
    GAME_EVENT_INFO_LOGO = ByCss('div.event-game-info img')
    SHARE_BUTTON = ByClass('tw-button--hollow')
    SHARE_DOCK_ITEMS = ByCss('ul.share-sheet__list li')
    DESCRIPTION = ByClass('event-description')

    def is_month_displayed(self):
        """Return a bool if the month from the given list is displayed."""
        month = ['JAN', 'FEB', 'MAR', 'APR', 'MAY', 'JUN', 'JUL',
                 'AUG', 'SEP', 'OCT', 'NOV', 'DEC']
        month_element = self.driver.find_element(*self.EVENT_CALENDAR_MONTH)
        return month_element.text in month

    def is_day_displayed(self):
        """Return a bool if the day from the provided range is displayed."""
        calendar_text = self.driver.find_element(*self.EVENT_CALENDAR_DAY).text
        return int(calendar_text) in range(1, 32)

    def timestamp_on_events_page(self):
        """Return a String of current timestamp on the events page."""
        return self.driver.find_element(*self.TIMESTAMP).text

    def is_channel_with_logo_present(self):
        """Return a bool if both channel name and channel logo are present."""
        info_text = self.driver.find_element(*self.CHANNEL_EVENT_INFO).text
        src_element = self.driver.find_element(*self.CHANNEL_EVENT_INFO_LOGO)
        src = src_element.get_attribute('src')
        channel_name = 'Twitch' in info_text
        channel_logo = 'twitch' in src
        return channel_name and channel_logo

    def is_game_with_logo_present(self):
        """Return a bool if both game name and game logo are present."""
        info_text = self.driver.find_element(*self.GAME_EVENT_INFO).text
        src_element = self.driver.find_element(*self.GAME_EVENT_INFO_LOGO)
        src = src_element.get_attribute('src')
        game_name = 'Talk Shows' in info_text
        game_logo = "Talk%20Shows" in src
        return game_name and game_logo

    def expand_share_options(self):
        """Expand the share options on events page."""
        self.driver.find_element(*self.SHARE_BUTTON).click()

    def share_dock_item_list(self):
        """Return a List of options in the share menu."""
        items = self.driver.find_elements(*self.SHARE_DOCK_ITEMS)
        return [item.text for item in items]

    def event_description_text(self):
        """Return a String of event description text."""
        return self.driver.find_element(*self.DESCRIPTION).text
